"""add more stage_score fields

Revision ID: 9357303f57a4
Revises: bd2fc147be53
Create Date: 2023-01-26 11:43:47.040775

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "9357303f57a4"
down_revision = "bd2fc147be53"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    from hitfactorpy_sqlalchemy.orm.models import SAEnumPowerFactor

    op.add_column("match_report_stage_score", sa.Column("raw_points", sa.Float(), nullable=True))
    op.add_column("match_report_stage_score", sa.Column("penalty_points", sa.Float(), nullable=True))
    op.add_column("match_report_stage_score", sa.Column("total_points", sa.Float(), nullable=True))
    op.add_column("match_report_stage_score", sa.Column("hit_factor", sa.Float(), nullable=True))
    op.add_column("match_report_stage_score", sa.Column("stage_points", sa.Float(), nullable=True))
    op.add_column("match_report_stage_score", sa.Column("stage_place", sa.Integer(), nullable=True))
    op.add_column(
        "match_report_stage_score",
        sa.Column(
            "stage_power_factor",
            SAEnumPowerFactor,
            nullable=True,
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("match_report_stage_score", "stage_power_factor")
    op.drop_column("match_report_stage_score", "stage_place")
    op.drop_column("match_report_stage_score", "stage_points")
    op.drop_column("match_report_stage_score", "hit_factor")
    op.drop_column("match_report_stage_score", "total_points")
    op.drop_column("match_report_stage_score", "penalty_points")
    op.drop_column("match_report_stage_score", "raw_points")
    # ### end Alembic commands ###
